<?php

$_SESSION["preset"] = 6;

/**

 * Template Name: Demo 6

 *

 * Description: A page template that provides a key component of WordPress as a CMS

 * by meeting the need for a carefully crafted introductory page. The front page template

 * in Twenty Twelve consists of a page content area for adding text, images, video --

 * anything you'd like -- followed by front-page-only widgets in one or two columns.

 *

 * @package WordPress

 * @subpackage Twenty_Twelve

 * @since Twenty Twelve 1.0

 */

?>

<!DOCTYPE html>

<!--[if IE 7]>

<html class="ie ie7" <?php language_attributes(); ?>>

<![endif]-->

<!--[if IE 8]>

<html class="ie ie8" <?php language_attributes(); ?>>

<![endif]-->

<!--[if !(IE 7) | !(IE 8)  ]><!-->

<html <?php language_attributes(); ?>>

<!--<![endif]-->

<head>

<?php global $organica_opt; ?>

<meta charset="<?php bloginfo( 'charset' ); ?>" />

<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="profile" href="http://gmpg.org/xfn/11" />

<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

<?php 

if(isset($organica_opt['opt-favicon']) && $organica_opt['opt-favicon']!="") { 

	if(is_ssl()){

		$organica_opt['opt-favicon'] = str_replace('http', 'https', $organica_opt['opt-favicon']);

	}

?>

	<link rel="icon" type="image/png" href="<?php echo esc_url($organica_opt['opt-favicon']['url']);?>">

<?php } ?>

<?php

$jscomposer_templates_args = array(

	'orderby'          => 'title',

	'order'            => 'ASC',

	'post_type'        => 'templatera',

	'post_status'      => 'publish',

	'posts_per_page'   => 30,

);

$jscomposer_templates = get_posts( $jscomposer_templates_args );



if(count($jscomposer_templates) > 0) {

	foreach($jscomposer_templates as $jscomposer_template){

		if($jscomposer_template->post_title == 'Header 3' || $jscomposer_template->post_title == 'Footer 1'){

			$jscomposer_template_css = get_post_meta ( $jscomposer_template->ID, '_wpb_shortcodes_custom_css', false );

			if(isset($jscomposer_template_css[0])){

				echo '<style>'.esc_html($jscomposer_template_css[0]).'</style>';

			}

		}

	}

} ?>

<?php wp_head(); ?>

</head>



<body <?php body_class('home'); ?>>

	<div id="yith-wcwl-popup-message" style="display:none;"><div id="yith-wcwl-message"></div></div>

	<div class="wrapper <?php if($organica_opt['page_layout']=='box'){echo 'box-layout';}?>">

		<div class="page-wrapper">

			<div class="header-container header-3 rs-active">

				<div class="header">

					<div class="header-content">

						<?php

						if ( isset($organica_opt['header_layout']) && $organica_opt['header_layout']!="") {

							$jscomposer_templates_args = array(

								'orderby'          => 'title',

								'order'            => 'ASC',

								'post_type'        => 'templatera',

								'post_status'      => 'publish',

								'posts_per_page'   => 30,

							);

							$jscomposer_templates = get_posts( $jscomposer_templates_args );



							if(count($jscomposer_templates) > 0) {

								foreach($jscomposer_templates as $jscomposer_template){

									if($jscomposer_template->post_title == 'Header 3'){ /* header template name */

										echo do_shortcode($jscomposer_template->post_content);

									}

								}

							}

						}

						?>

					</div>

				</div>

				<div class="clearfix"></div>

			</div>

			<div class="main-container">

				<div class="page-content front-page">

					<?php while ( have_posts() ) : the_post(); ?>

						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

							<div class="entry-content">

								<?php the_content(); ?>

							</div>

						</article>

					<?php endwhile; ?>

					

				</div>

			</div>

			<div class="footer footer-1">

				<?php

				if ( isset($organica_opt['footer_layout']) && $organica_opt['footer_layout']!="" ) {



					$jscomposer_templates_args = array(

						'orderby'          => 'title',

						'order'            => 'ASC',

						'post_type'        => 'templatera',

						'post_status'      => 'publish',

						'posts_per_page'   => 30,

					);

					$jscomposer_templates = get_posts( $jscomposer_templates_args );



					if(count($jscomposer_templates) > 0) {

						foreach($jscomposer_templates as $jscomposer_template){

							if($jscomposer_template->post_title == 'Footer 1'){ /* footer template name */

								echo do_shortcode($jscomposer_template->post_content);

							}

						}

					}

				} else { ?>

					<div class="widget-copyright">

						<?php 

						if( isset($organica_opt['copyright']) && $organica_opt['copyright']!='' ) {

							echo wp_kses($organica_opt['copyright'], array(

								'a' => array(

									'href' => array(),

									'title' => array()

								),

								'br' => array(),

								'em' => array(),

								'strong' => array(),

							));

						} else {

							echo 'Copyright <a href="'.esc_url( home_url( '/' ) ).'">'.get_bloginfo('name').'</a> '.date('Y').'. All Rights Reserved';

						}

						?>

					</div>

				<?php

				}

				?>

			</div>

		</div><!-- .page -->

	</div><!-- .wrapper -->

	<!--<div class="organica_loading"></div>-->

	<div id="back-top" class="hidden-xs hidden-sm hidden-md"></div>

	<?php wp_footer(); ?>

</body>

</html>

<?php unset($_SESSION["preset"]); ?>